<?php
// /home/ubuntu/vtrius_web_system/src/Views/user/videos/list.php

// $videos array is passed from VideoController::listVideos()
// $pageTitleKey should be passed from controller, e.g., "my_videos_title"
$pageTitle = isset($pageTitleKey) ? __($pageTitleKey) : __("my_videos_title");

?>

<h2><?php echo $pageTitle; ?></h2>

<p><a href="<?php echo BASE_URL; ?>/user/videos/upload.php" class="button"><?php echo __("upload_new_video_button"); ?></a></p>

<?php if (empty($videos)): ?>
    <p><?php echo __("no_videos_uploaded"); ?></p>
<?php else: ?>
    <style>
        /* Styles remain the same */
        .video-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .video-table th, .video-table td {
            border: 1px solid #dee2e6;
            padding: 10px 12px;
            text-align: left;
            vertical-align: middle;
        }
        .video-table th {
            background-color: #e9ecef;
            font-weight: bold;
        }
        .video-table tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        .video-table .actions form {
            display: inline-block;
            margin: 0 5px 0 0;
        }
        .video-table .actions button,
        .video-table .actions a.button {
            padding: 5px 10px;
            font-size: 0.9em;
        }
        .video-table .actions .btn-delete {
             background-color: #dc3545;
             color: white;
        }
        .video-table .actions .btn-edit {
             background-color: #0d6efd;
             color: white;
        }
        .video-table .actions .btn-settings {
             background-color: #6c757d;
             color: white;
        }
        .video-table code {
             background-color: #e9ecef;
             padding: 2px 4px;
             border-radius: 3px;
             font-family: monospace;
             font-size: 0.9em;
             word-break: break-all;
        }
    </style>

    <table class="video-table">
        <thead>
            <tr>
                <th><?php echo __("video_title"); ?></th>
                <th><?php echo __("video_upload_date"); ?></th>
                <th><?php echo __("video_shortcode_embed"); ?></th>
                <th><?php echo __("actions"); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($videos as $video): ?>
            <tr>
                <td><?php echo htmlspecialchars($video["title"]); ?></td>
                <td><?php echo (new DateTime($video["created_at"]))->format("d/m/Y H:i"); // Date format might need localization later ?></td>
                <td>
                    <?php 
                    // Placeholder for embed code generation - To be implemented later
                    $embedCode = 
                    "<script src=\"" . BASE_URL . "/player.js?v=" . $video["id"] . "\" async></script>"; 
                    ?>
                    <code><?php echo htmlspecialchars("[vtrius_video id=\"{$video["id"]}\"]"); // Simple shortcode example ?></code>
                    <br>
                    <small><?php echo __("video_embed_js_example"); ?>:</small><br>
                    <code><?php echo htmlspecialchars($embedCode); ?></code>
                </td>
                <td class="actions">
                    <!-- Edit Title (Example - could be AJAX or separate page) -->
                    <!-- <button class="btn-edit"><?php echo __("edit"); ?></button> --> 
                    
                    <!-- Settings Page Link -->
                    <a href="<?php echo BASE_URL; ?>/user/videos/settings.php?id=<?php echo $video["id"]; ?>" class="button btn-settings"><?php echo __("video_configure_button"); ?></a>

                    <!-- Delete Form -->
                    <form action="<?php echo BASE_URL; ?>/user/videos/delete.php" method="post" onsubmit="return confirm("<?php echo htmlspecialchars(__("confirm_delete_video")); ?>");">
                        <input type="hidden" name="video_id" value="<?php echo $video["id"]; ?>">
                        <button type="submit" class="btn-delete"><?php echo __("delete"); ?></button>
                    </form>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>


