<?php
// /home/ubuntu/vtrius_web_system/src/Views/user/abtests/list.php

// $tests array is passed from AbTestController::listTests()
// $pageTitleKey is set by the controller

$pageTitle = isset($pageTitleKey) ? __($pageTitleKey) : __("ab_tests_list_title");

?>

<h2><?php echo $pageTitle; ?></h2>

<p><a href="<?php echo BASE_URL; ?>/user/abtests/create.php" class="button"><?php echo __("ab_test_create_new_button"); ?></a></p>

<?php if (empty($tests)): ?>
    <p><?php echo __("ab_test_no_tests_created"); ?></p>
<?php else: ?>
    <style>
        /* Reusing video-table styles, maybe rename to data-table? */
        .abtest-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .abtest-table th, .abtest-table td {
            border: 1px solid #dee2e6;
            padding: 10px 12px;
            text-align: left;
            vertical-align: middle;
        }
        .abtest-table th {
            background-color: #e9ecef;
            font-weight: bold;
        }
        .abtest-table tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        .abtest-table .actions form {
            display: inline-block;
            margin: 0 5px 0 0;
        }
        .abtest-table .actions button,
        .abtest-table .actions a.button {
            padding: 5px 10px;
            font-size: 0.9em;
        }
        .abtest-table .actions .btn-delete {
             background-color: #dc3545;
             color: white;
        }
        .abtest-table .actions .btn-view {
             background-color: #0d6efd;
             color: white;
        }
    </style>

    <table class="abtest-table">
        <thead>
            <tr>
                <th><?php echo __("ab_test_name_column"); ?></th>
                <th><?php echo __("ab_test_created_date_column"); ?></th>
                <th><?php echo __("actions"); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($tests as $test): ?>
            <tr>
                <td><?php echo htmlspecialchars($test["name"]); ?></td>
                <td><?php echo (new DateTime($test["created_at"]))->format("d/m/Y H:i"); ?></td>
                <td class="actions">
                    <a href="<?php echo BASE_URL; ?>/user/abtests/view.php?id=<?php echo $test["id"]; ?>" class="button btn-view"><?php echo __("ab_test_view_button"); ?></a>
                    
                    <!-- Delete Form -->
                    <form action="<?php echo BASE_URL; ?>/user/abtests/delete.php" method="post" onsubmit="return confirm('<?php echo htmlspecialchars(__("ab_test_confirm_delete")); ?>');">
                        <input type="hidden" name="test_id" value="<?php echo $test["id"]; ?>">
                        <button type="submit" class="btn-delete"><?php echo __("delete"); ?></button>
                    </form>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>

<?php
// Add new translation keys:
/*
"ab_tests_list_title" => "Meus Testes A/B",
"ab_test_create_new_button" => "Criar Novo Teste A/B",
"ab_test_no_tests_created" => "Você ainda não criou nenhum Teste A/B.",
"ab_test_name_column" => "Nome do Teste",
"ab_test_created_date_column" => "Data de Criação",
"ab_test_view_button" => "Ver / Gerenciar",
"ab_test_confirm_delete" => "Tem certeza que deseja excluir este teste A/B e todas as suas variações e estatísticas? Esta ação não pode ser desfeita.",
*/
?>

