<?php
// /home/ubuntu/vtrius_web_system/src/Views/user/abtests/create.php

// $videos array is passed from AbTestController::showCreateForm()
// $pageTitleKey is set by the controller

$pageTitle = isset($pageTitleKey) ? __($pageTitleKey) : __("ab_test_create_title");

?>

<h2><?php echo $pageTitle; ?></h2>

<form action="<?php echo BASE_URL; ?>/user/abtests/create.php" method="post">

    <div class="form-group">
        <label for="name"><?php echo __("ab_test_form_name_label"); ?></label>
        <input type="text" id="name" name="name" required>
        <small><?php echo __("ab_test_form_name_desc"); ?></small>
    </div>

    <div class="form-group">
        <label for="main_video_id"><?php echo __("ab_test_form_control_video_label"); ?></label>
        <select id="main_video_id" name="main_video_id" required>
            <option value=""><?php echo __("ab_test_form_select_video_option"); ?></option>
            <?php foreach ($videos as $video): ?>
                <option value="<?php echo $video["id"]; ?>">
                    <?php echo htmlspecialchars($video["title"]); ?> (ID: <?php echo $video["id"]; ?>)
                </option>
            <?php endforeach; ?>
        </select>
        <small><?php echo __("ab_test_form_control_video_desc"); ?></small>
    </div>

    <button type="submit" class="button"><?php echo __("ab_test_create_button_submit"); ?></button>
    <a href="<?php echo BASE_URL; ?>/user/abtests.php" style="margin-left: 15px;"><?php echo __("cancel"); ?></a>

</form>

<?php
// Add new translation keys:
/*
"ab_test_create_title" => "Criar Novo Teste A/B",
"ab_test_form_name_label" => "Nome do Teste A/B:",
"ab_test_form_name_desc" => "Um nome descritivo para identificar este teste.",
"ab_test_form_control_video_label" => "Vídeo de Controle (Principal):",
"ab_test_form_select_video_option" => "-- Selecione um vídeo --",
"ab_test_form_control_video_desc" => "Este será o vídeo base (controle) para comparação. Você adicionará outras variações depois.",
"ab_test_create_button_submit" => "Criar Teste e Adicionar Variações",
"ab_test_error_no_videos" => "Você precisa carregar pelo menos um vídeo antes de criar um Teste A/B.",
"ab_test_error_missing_fields" => "Por favor, preencha o nome do teste e selecione um vídeo de controle.",
"ab_test_error_video_not_owned" => "O vídeo selecionado não foi encontrado ou não pertence a você.",
"ab_test_create_success" => "Teste A/B ":name" criado com sucesso! Agora adicione as variações.",
"ab_test_create_error" => "Erro ao criar o Teste A/B.",
*/
?>

