<?php
// /home/ubuntu/vtrius_web_system/src/Views/layouts/user_header.php

use Vtrius\Lib\I18n;
use Vtrius\Lib\Auth;
use Vtrius\Models\User;

// Ensure auth is available (should be checked by controller, but good practice)
if (!isset($auth)) {
    $auth = new Auth();
}

// Fetch user details for display (can be optimized later)
$currentUser = null;
if ($auth->isLoggedIn()) {
    $userModel = new User();
    $currentUser = $userModel->findById($auth->getUserId());
    // Add logic to check expiry and potentially display warnings
    $expiryWarning = false;
    $isExpired = false;
    $isFrozen = ($currentUser && $currentUser["status"] === "frozen"); // Check for frozen status

    if ($currentUser && !$currentUser["is_admin"] && $currentUser["expiry_date"]) {
        try {
            $expiryDate = new DateTime($currentUser["expiry_date"]);
            $now = new DateTime();
            $diff = $now->diff($expiryDate);
            $isExpired = $diff->invert; // invert is 1 if expiry date is in the past

            // Warn if less than 7 days remaining and not already expired
            if (!$isExpired && $diff->days <= 7) {
                $expiryWarning = true;
            }
        } catch (Exception $e) { /* Ignore date parsing errors */ }
    }
}

// Determine current language for html tag and flag display
$currentLang = I18n::getCurrentLang();
$htmlLang = str_replace("_", "-", $currentLang); // Format for lang attribute (e.g., pt-BR)

// Set page title using translation if available
$pageTitleKey = isset($pageTitleKey) ? $pageTitleKey : "vtrius"; // Use a key passed from controller or default
$pageTitle = __(htmlspecialchars($pageTitleKey)) . " - " . __("vtrius");

?>
<!DOCTYPE html>
<html lang="<?php echo $htmlLang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?></title>
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/style.css">
    <style>
        /* User Area Specific Styles */
        body {
            display: flex;
            min-height: 100vh;
            background-color: #f8f9fa;
        }
        .sidebar {
            width: 250px;
            background-color: #2F4F2F; /* Dark Moss Green */
            color: #e9ecef;
            padding: 20px 0;
            display: flex;
            flex-direction: column;
        }
        .sidebar h1 {
            color: #ffffff;
            text-align: center;
            margin: 0 0 30px 0;
            font-size: 1.8em;
        }
        .sidebar nav ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        .sidebar nav ul li a {
            display: block;
            color: #ced4da;
            padding: 12px 20px;
            text-decoration: none;
            transition: background-color 0.2s ease, color 0.2s ease;
            border-left: 3px solid transparent;
        }
        .sidebar nav ul li a:hover,
        .sidebar nav ul li.active a /* Add .active class based on current page */
        {
            background-color: #556B2F; /* Dark Olive Green */
            color: #ffffff;
            border-left-color: #90EE90; /* Light Green */
        }
        .sidebar .user-info {
            padding: 20px;
            font-size: 0.9em;
            border-top: 1px solid #556B2F;
        }
        .sidebar .user-info p {
            margin: 5px 0;
        }
        .sidebar .user-info .expiry-warning {
             color: #ffc107; /* Warning yellow */
             font-weight: bold;
        }
        .sidebar .user-info .status-expired,
        .sidebar .user-info .status-frozen /* Style for expired/frozen status */
        {
             color: #dc3545; /* Danger red */
             font-weight: bold;
        }
        .sidebar .lang-selector {
             margin-top: auto; /* Pushes user info and lang selector down */
             padding: 10px 20px;
             text-align: center;
        }
        .sidebar .lang-selector a {
             display: inline-block;
             margin: 0 5px;
             opacity: 0.7;
             transition: opacity 0.2s ease;
        }
        .sidebar .lang-selector a:hover,
        .sidebar .lang-selector a.active-lang {
             opacity: 1.0;
        }
        .sidebar .lang-selector img {
             width: 24px;
             height: auto;
             vertical-align: middle;
             border: 1px solid #ccc;
        }

        .main-content {
            flex: 1;
            padding: 30px;
            overflow-y: auto;
        }
        .main-content h2 {
             margin-top: 0;
             border-bottom: 1px solid #dee2e6;
             padding-bottom: 10px;
             margin-bottom: 20px;
        }
        /* Responsive adjustments can be added later */
    </style>
</head>
<body>
    <aside class="sidebar">
        <h1><?php echo __("vtrius"); ?></h1>
        <nav>
            <ul>
                <!-- Add active class dynamically based on current page -->
                <li><a href="<?php echo BASE_URL; ?>/user/dashboard.php"><?php echo __("menu_my_account"); ?></a></li>
                <li><a href="<?php echo BASE_URL; ?>/user/videos.php"><?php echo __("menu_manage_videos"); ?></a></li>
                <li><a href="<?php echo BASE_URL; ?>/user/videos/upload.php"><?php echo __("menu_upload_video"); ?></a></li>
                <li><a href="<?php echo BASE_URL; ?>/user/abtests.php"><?php echo __("menu_ab_tests"); ?></a></li>
                <!-- Add more items as needed -->
            </ul>
        </nav>

        <div class="lang-selector">
            <?php
            // Simple flag display - assumes flag images exist in assets/img/flags/
            $langs = I18n::getSupportedLangs();
            $flagMap = ["pt_BR" => "br.png", "en_US" => "us.png", "es_ES" => "es.png"];
            foreach ($langs as $langCode) {
                $flagFile = $flagMap[$langCode] ?? "";
                $isActive = ($langCode === $currentLang) ? "active-lang" : "";
                if ($flagFile) {
                    echo 
                    sprintf(
                        '<a href="?lang=%s" class="%s" title="%s"><img src="%s/assets/img/flags/%s" alt="%s"></a>',
                        $langCode,
                        $isActive,
                        $langCode, // Title attribute for clarity
                        BASE_URL,
                        $flagFile,
                        $langCode
                    );
                }
            }
            ?>
        </div>

        <div class="user-info">
            <?php if ($currentUser): ?>
                <p><?php echo __("user_info_user"); ?>: <strong><?php echo htmlspecialchars($currentUser["username"]); ?></strong></p>
                <p><?php echo __("user_info_status"); ?>: 
                    <span class="status-<?php echo htmlspecialchars($currentUser["status"]); ?>">
                        <?php 
                        // Translate status
                        $statusKey = "status_" . $currentUser["status"]; // e.g., status_active, status_frozen
                        echo __(htmlspecialchars($statusKey)); 
                        ?>
                    </span>
                </p>
                <?php if ($currentUser["expiry_date"] && !$currentUser["is_admin"]): ?>
                    <p class="<?php echo $expiryWarning ? "expiry-warning" : ""; ?> <?php echo $isExpired ? "status-expired" : ""; ?>">
                        <?php echo __("user_info_expires"); ?>: <?php echo (new DateTime($currentUser["expiry_date"]))->format("d/m/Y"); ?>
                    </p>
                <?php endif; ?>
                 <?php if ($isFrozen): // Display frozen message ?>
                    <p class="status-frozen"><?php echo __("account_frozen_message"); ?></p>
                <?php endif; ?>
            <?php endif; ?>
            <p style="margin-top: 15px;"><a href="<?php echo BASE_URL; ?>/logout.php" style="color: #adb5bd;"><?php echo __("logout"); ?></a></p>
        </div>
    </aside>

    <main class="main-content">
        <?php
        // Display flash messages within the main content area
        if (isset($_SESSION["flash_message"])) {
            $messageData = $_SESSION["flash_message"];
            unset($_SESSION["flash_message"]);
            // Assume flash messages are already translated or are simple keys
            $messageText = isset($messageData["key"]) ? __($messageData["key"], $messageData["params"] ?? []) : ($messageData["message"] ?? "");
            echo 
            '<div class="flash-message flash-' . htmlspecialchars($messageData["type"]) . '">' . htmlspecialchars($messageText) . '</div>';
        }
        ?>
        <!-- Page specific content starts here -->

