<?php
// /home/ubuntu/vtrius_web_system/src/config.php

// Error Reporting (Development vs Production)
// For development, show all errors
ini_set("display_errors", 1);
ini_set("display_startup_errors", 1);
error_reporting(E_ALL);
// For production, you should disable display_errors and log errors instead
// ini_set("display_errors", 0);
// ini_set("log_errors", 1);
// ini_set("error_log", __DIR__ . "/../logs/php_error.log"); // Ensure logs directory exists and is writable

// --- Core Settings ---

// Base URL (useful for generating absolute URLs)
// Detect automatically or set manually if needed
$protocol = (!empty($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] !== "off") ? "https" : "http";
$host = $_SERVER["HTTP_HOST"] ?? "localhost"; // Default to localhost if not in web context
define("BASE_URL", $protocol . "://" . $host);

// Application Root Path
define("APP_ROOT", __DIR__); // Points to /home/ubuntu/vtrius_web_system/src
define("PROJECT_ROOT", dirname(__DIR__)); // Points to /home/ubuntu/vtrius_web_system

// --- Database Settings ---

// Absolute path to the SQLite database file
define("DB_PATH", PROJECT_ROOT . "/db/vtrius_database.db");

// --- Authentication Settings ---

// Default Admin User (Consider creating this via a setup script or manually in admin panel later)
// define("DEFAULT_ADMIN_USERNAME", "admin");
// define("DEFAULT_ADMIN_PASSWORD", "changeme"); // CHANGE THIS!
// define("DEFAULT_ADMIN_EMAIL", "admin@example.com");

// Session Settings (Optional: customize session behavior)
// ini_set("session.gc_maxlifetime", "7200"); // Session timeout in seconds (e.g., 2 hours)
// ini_set("session.cookie_lifetime", "0"); // Cookie lasts until browser is closed
// ini_set("session.cookie_secure", isset($_SERVER["HTTPS"])); // Send cookie only over HTTPS if available
// ini_set("session.cookie_httponly", "1"); // Prevent JS access to session cookie
// ini_set("session.use_strict_mode", "1"); // Prevent session adoption

// --- Upload Settings ---

define("UPLOADS_DIR", PROJECT_ROOT . "/public/uploads");
define("VIDEOS_DIR", UPLOADS_DIR . "/videos");
define("OVERLAYS_DIR", UPLOADS_DIR . "/overlays");
define("PAUSE_COVERS_DIR", UPLOADS_DIR . "/pause_covers");

// Max upload size (example: 500MB) - Ensure php.ini also allows this (upload_max_filesize, post_max_size)
define("MAX_UPLOAD_SIZE_MB", 500);

// Allowed video MIME types
define("ALLOWED_VIDEO_MIMES", [
    "video/mp4",
    "video/webm",
    "video/ogg"
    // Add more as needed
]);

// Allowed image MIME types (for overlays, pause covers)
define("ALLOWED_IMAGE_MIMES", [
    "image/jpeg",
    "image/png",
    "image/gif",
    "image/webp"
]);

// --- Other Settings ---

// Default user account validity (in days) when created by admin
define("DEFAULT_ACCOUNT_VALIDITY_DAYS", 30);

// Include Composer Autoloader if using Composer
// if (file_exists(PROJECT_ROOT . "/vendor/autoload.php")) {
//     require_once PROJECT_ROOT . "/vendor/autoload.php";
// }

// Basic Autoloader (if not using Composer)
spl_autoload_register(function ($class) {
    // Project-specific namespace prefix
    $prefix = "Vtrius\\";
    $base_dir = APP_ROOT . "/"; // src/ directory

    // Does the class use the namespace prefix?
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        // No, move to the next registered autoloader
        return;
    }

    // Get the relative class name
    $relative_class = substr($class, $len);

    // Replace the namespace prefix with the base directory, replace namespace
    // separators with directory separators in the relative class name, append
    // with .php
    $file = $base_dir . str_replace("\\", "/", $relative_class) . ".php";

    // If the file exists, require it
    if (file_exists($file)) {
        require $file;
    }
});

// Initialize Database Connection (ensure path is set before getting connection)
try {
    Vtrius\Lib\Database::init(DB_PATH);
} catch (\Exception $e) {
    // Handle initialization error gracefully (log, show error page)
    error_log("FATAL: Database initialization failed: " . $e->getMessage());
    // In a real app, you might show a user-friendly error page here
    die("System configuration error. Please contact administrator.");
}

// Initialize I18n System
try {
    Vtrius\Lib\I18n::init();
} catch (\Exception $e) {
    error_log("FATAL: I18n initialization failed: " . $e->getMessage());
    // In a real app, you might show a user-friendly error page here
    die("System configuration error (I18n). Please contact administrator.");
}

// Start session (should be done after class loading and config)
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

?>
