<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? htmlspecialchars($pageTitle) : 'Vtrius'; ?></title>
    <!-- Basic CSS (can be replaced/extended later) -->
    <style>
        body {
            font-family: sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f7f6;
            color: #333;
        }
        .container {
            max-width: 1200px;
            margin: 20px auto;
            padding: 20px;
            background-color: #fff;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            border-radius: 5px;
        }
        h1, h2, h3 {
            color: #2F4F2F; /* Dark Moss Green */
        }
        a { color: #556B2F; /* Dark Olive Green */ text-decoration: none; }
        a:hover { text-decoration: underline; }
        nav {
            background-color: #2F4F4F; /* Dark Slate Gray - Placeholder */
            color: white;
            padding: 10px 20px;
            margin-bottom: 20px;
            border-radius: 5px 5px 0 0;
        }
        nav a {
            color: white;
            margin-right: 15px;
        }
        .flash-message {
            padding: 10px 15px;
            margin-bottom: 15px;
            border-radius: 4px;
            border: 1px solid transparent;
        }
        .flash-success {
            background-color: #d4edda;
            color: #155724;
            border-color: #c3e6cb;
        }
        .flash-error {
            background-color: #f8d7da;
            color: #721c24;
            border-color: #f5c6cb;
        }
        /* Add more base styles as needed */
    </style>
    <!-- Link to main CSS file -->
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/style.css">
</head>
<body>

<?php 
// Basic check for session flash messages (can be improved)
if (isset($_SESSION['flash_message'])) {
    $message = $_SESSION['flash_message'];
    unset($_SESSION['flash_message']);
    echo '<div class="flash-message flash-' . htmlspecialchars($message['type']) . '">' . htmlspecialchars($message['message']) . '</div>';
}
?>

<!-- Main content will be included here -->

