<?php
// /home/ubuntu/vtrius_web_system/src/Views/partials/video_player.php

/**
 * Renders the placeholder for the Vtrius video player.
 * Expects $video and $settings variables to be available in the scope where it's included.
 *
 * @var array $video Video data from the `videos` table.
 * @var array $settings Video settings data from the `video_settings` table.
 */

if (!isset($video) || !isset($settings)) {
    echo "<!-- Error: Video or settings data missing for player partial -->";
    return;
}

$videoId = $video["id"];
$containerId = "vtrius-player-container-" . $videoId;

// Prepare data attributes for the JS player
$dataAttributes = [
    "data-vtrius-id" => $videoId,
    // We need the actual video URL - this requires constructing it based on storage_path
    // Assuming storage_path is relative like 'USER_ID/filename.mp4'
    "data-video-url" => BASE_URL . "/uploads/videos/" . htmlspecialchars($video["storage_path"]), 
    "data-hide-controls" => $settings["hide_controls"] ? "true" : "false",
    // Autoplay needs careful consideration - often blocked by browsers
    // "data-autoplay" => isset($settings["autoplay"]) && $settings["autoplay"] ? "true" : "false", 
    "data-overlay-image" => $settings["overlay_image_path"] ? BASE_URL . "/uploads/overlays/" . htmlspecialchars($settings["overlay_image_path"]) : "",
    "data-overlay-opacity" => $settings["overlay_opacity"] ?? 1.0,
    "data-pause-cover" => $settings["pause_cover_image_path"] ? BASE_URL . "/uploads/pause_covers/" . htmlspecialchars($settings["pause_cover_image_path"]) : "",
    "data-pause-text" => htmlspecialchars($settings["pause_cover_text"] ?? __("pause_cover_default_text")), // Use translated default
    "data-pitch-time" => $settings["pitch_time_seconds"] ?? "",
    "data-pitch-target" => htmlspecialchars($settings["pitch_target_selector"] ?? ""),
    "data-pitch-button-text" => htmlspecialchars($settings["pitch_button_text"] ?? ""),
    "data-pitch-button-url" => htmlspecialchars($settings["pitch_button_url"] ?? ""),
    "data-autoplay" => $settings["autoplay"] ? "true" : "false", // Added autoplay
    // Add data attributes for translated button texts if needed by JS
    "data-text-continue" => __("pause_cover_continue_button"),
    "data-text-restart" => __("pause_cover_restart_button"),
];

// Filter out empty attributes
$dataAttributesString = "";
foreach ($dataAttributes as $key => $value) {
    if ($value !== "" && !is_null($value)) {
        $dataAttributesString .= " " . $key . "=\"" . $value . "\"";
    }
}

?>

<!-- Vtrius Player Placeholder -->
<div id="<?php echo $containerId; ?>" <?php echo $dataAttributesString; ?> style="width: 100%; max-width: 100%; /* Or set specific dimensions */ aspect-ratio: 16 / 9; /* Maintain aspect ratio */ background-color: #000; /* Placeholder background */">
    <!-- The JS player will populate this div -->
    <!-- Optional: Add a loading indicator or poster image here -->
</div>

<?php 
// Ensure the player script is loaded (ideally only once per page)
// This could be handled by a central script loader or just included here for simplicity
// A more robust solution would check if the script is already included.
// echo '<script src="' . BASE_URL . '/assets/js/vtrius-player.js" async></script>'; 
// It's better to load the script globally in the footer and let it find all placeholders.
?>

