<?php
// /home/ubuntu/vtrius_web_system/src/Locale/en_US/messages.php

// Translations for US English (en_US)

return [
    // General
    "vtrius" => "Vtrius",
    "error" => "Error",
    "success" => "Success",
    "cancel" => "Cancel",
    "delete" => "Delete",
    "edit" => "Edit",
    "save" => "Save",
    "actions" => "Actions",
    "yes" => "Yes",
    "no" => "No",
    "confirm_delete_video" => "Are you sure you want to delete this video? This action cannot be undone.",
    "invalid_request" => "Invalid request",
    "method_not_allowed" => "Method Not Allowed",
    "view_not_found" => "Error: View not found (:path)",
    "copyright" => "© :year Vtrius. All rights reserved.",

    // Login / Authentication
    "login_title" => "Login - Vtrius",
    "login_heading" => "Vtrius Login",
    "username" => "Username",
    "password" => "Password",
    "login_button" => "Login",
    "logout" => "Logout",
    "login_error_invalid" => "Invalid username or password, or account inactive.",
    "login_error_inactive" => "Your account is inactive or expired. Please contact support.",
    "login_error_access_denied" => "Access denied.",
    "forgot_password" => "Forgot password?", // Placeholder

    // User Layout
    "user_area_title" => "User Area - Vtrius",
    "menu_my_account" => "My Account",
    "menu_manage_videos" => "Manage Videos",
    "menu_upload_video" => "Upload Video",
    "menu_ab_tests" => "A/B Tests",
    "user_info_user" => "User",
    "user_info_status" => "Status",
    "user_info_expires" => "Expires on",
    "status_active" => "Active",
    "status_inactive" => "Inactive",
    "status_expired" => "Expired",
    "status_frozen" => "Frozen", // Added based on user request

    // Video Management
    "my_videos_title" => "My Videos",
    "upload_new_video_button" => "Upload New Video",
    "no_videos_uploaded" => "You haven't uploaded any videos yet.",
    "video_title" => "Title",
    "video_upload_date" => "Upload Date",
    "video_shortcode_embed" => "Shortcode / Embed",
    "video_embed_js_example" => "Embed JS (Example)",
    "video_configure_button" => "Configure",
    "video_delete_success" => "Video deleted successfully.",
    "video_delete_error" => "Error deleting video. It may not exist or you don't have permission.",

    // Video Upload
    "upload_video_title" => "Upload New Video",
    "form_video_title_label" => "Video Title:",
    "form_video_file_label" => "Video File:",
    "form_video_allowed_types" => "Allowed types: MP4, WebM, Ogg. Max size: :size MB.",
    "upload_video_button_submit" => "Upload Video",
    "upload_success" => "Video ':title' uploaded successfully!",
    "upload_error_generic" => "Upload error: :message",
    "upload_error_file_type" => "Error: Invalid video file type.",
    "upload_error_size_limit" => "Error: Video file exceeds the maximum allowed size (:size MB).",
    "upload_error_cannot_create_dir" => "Error: Could not create upload directory.",
    "upload_error_cannot_save_db" => "Error: Could not save video information to the database.",
    "upload_error_cannot_move_file" => "Error: Failed to move uploaded file to destination.",
    // Upload error messages from PHP
    "upload_err_ini_size" => "The uploaded file exceeds the upload_max_filesize directive in php.ini.",
    "upload_err_form_size" => "The uploaded file exceeds the MAX_FILE_SIZE directive specified in the HTML form.",
    "upload_err_partial" => "The uploaded file was only partially uploaded.",
    "upload_err_no_file" => "No file was uploaded.",
    "upload_err_no_tmp_dir" => "Missing a temporary folder.",
    "upload_err_cant_write" => "Failed to write file to disk.",
    "upload_err_extension" => "A PHP extension stopped the file upload.",
    "upload_err_unknown" => "Unknown upload error.",

    // Admin Area (Placeholders - to be added later)
    "admin_dashboard_title" => "Admin Dashboard",
    "admin_menu_manage_users" => "Manage Users",
    "admin_menu_create_user" => "Create Account",
    "admin_menu_frozen_accounts" => "Frozen Accounts",

    // Account Status
    "account_frozen_message" => "Account frozen, please pay to reactivate", // Added based on user request

    // Video Settings
    "video_settings_title" => "Video Settings: :title",
    "video_settings_title_default" => "Video Settings",
    "settings_section_player_behavior" => "Player Behavior",
    "setting_hide_controls_label" => "Hide default player controls",
    "setting_hide_controls_desc" => "If checked, the browser's native controls will be hidden.",
    "setting_autoplay_label" => "Autoplay (muted)",
    "setting_autoplay_desc" => "Attempts to start the video automatically (usually requires initial mute). May be blocked by browsers.",
    "settings_section_overlay" => "Image Overlay",
    "setting_overlay_image_label" => "Overlay Image",
    "remove_current_image" => "Remove current image",
    "form_image_allowed_types" => "Allowed types: JPG, PNG, GIF, WebP. Max size: 5MB.",
    "setting_overlay_opacity_label" => "Overlay Opacity",
    "setting_overlay_opacity_desc" => "Sets the transparency of the overlay image (0 = transparent, 1 = opaque).",
    "settings_section_pause_cover" => "Pause Cover",
    "setting_pause_cover_image_label" => "Pause Cover Image",
    "setting_pause_cover_text_label" => "Text on Pause Cover",
    "pause_cover_default_text" => "You were watching...",
    "setting_pause_cover_text_desc" => "Text displayed over the image when the video is paused.",
    "settings_section_pitch_container" => "Pitch / CTA",
    "setting_pitch_time_label" => "Time to display Pitch (in seconds)",
    "setting_pitch_time_desc" => "Leave blank to disable. Content will be displayed after this time.",
    "setting_pitch_target_selector_label" => "Pitch Container CSS Selector",
    "setting_pitch_target_selector_desc" => "E.g., #my-id, .my-class. The player will remove the 'vtrius-pitch-hidden' class from this element at the set time.",
    "setting_pitch_option_or" => "OR",
    "setting_pitch_button_text_label" => "Pitch Button Text",
    "setting_pitch_button_text_desc" => "Text that will appear on the button displayed at pitch time.",
    "setting_pitch_button_url_label" => "Pitch Button URL",
    "setting_pitch_button_url_desc" => "Destination link for the button click.",
    "setting_pitch_button_note" => "If Button Text and URL are filled, the button will be displayed instead of activating the CSS selector.",
    "save_settings" => "Save Settings",
    "back_to_videos" => "Back to Videos",
    "video_settings_update_success" => "Video settings updated successfully.",
    "video_settings_update_error" => "Error updating video settings.",
    "upload_error_image_type" => "Error: Invalid image file type.",
    "upload_error_image_size" => "Error: Image file exceeds the maximum allowed size (:size MB).",
    "pause_cover_continue_button" => "Continue Watching", // Used by JS player
    "pause_cover_restart_button" => "Restart from Beginning", // Used by JS player

    // A/B Tests
    "ab_tests_list_title" => "My A/B Tests",
    "ab_test_create_new_button" => "Create New A/B Test",
    "ab_test_no_tests_created" => "You haven't created any A/B Tests yet.",
    "ab_test_name_column" => "Test Name",
    "ab_test_created_date_column" => "Creation Date",
    "ab_test_view_button" => "View / Manage",
    "ab_test_confirm_delete" => "Are you sure you want to delete this A/B test and all its variations and statistics? This action cannot be undone.",
    "ab_test_create_title" => "Create New A/B Test",
    "ab_test_form_name_label" => "A/B Test Name:",
    "ab_test_form_name_desc" => "A descriptive name to identify this test.",
    "ab_test_form_control_video_label" => "Control (Main) Video:",
    "ab_test_form_select_video_option" => "-- Select a video --",
    "ab_test_form_control_video_desc" => "This will be the base (control) video for comparison. You will add other variations later.",
    "ab_test_create_button_submit" => "Create Test and Add Variations",
    "ab_test_error_no_videos" => "You need to upload at least one video before creating an A/B Test.",
    "ab_test_error_missing_fields" => "Please fill in the test name and select a control video.",
    "ab_test_error_video_not_owned" => "The selected video was not found or does not belong to you.",
    "ab_test_create_success" => "A/B Test \":name\" created successfully! Now add the variations.",
    "ab_test_create_error" => "Error creating the A/B Test.",
    "ab_test_view_title" => "Manage A/B Test: :name",
    "ab_test_view_title_default" => "Manage A/B Test",
    "ab_test_variations_heading" => "Test Variations",
    "ab_test_no_variations_yet" => "No variations added yet (except control).",
    "ab_test_video_title_column" => "Video Title",
    "ab_test_status_column" => "Status",
    "ab_test_control_label" => "Control",
    "ab_test_variation_label" => "Variation",
    "ab_test_confirm_remove_variation" => "Are you sure you want to remove this variation from the test?",
    "remove" => "Remove",
    "ab_test_add_variation_heading" => "Add New Variation",
    "ab_test_select_video_to_add" => "Select a video to add as a variation:",
    "ab_test_add_variation_button" => "Add Variation",
    "ab_test_variation_limit_desc" => "You can have up to 4 variations (including control) per test.",
    "ab_test_variation_limit_reached" => "Limit of 4 variations reached for this test.",
    "ab_test_stats_heading" => "Statistics (Coming Soon)",
    "ab_test_stats_coming_soon" => "Statistics collection and display will be implemented soon.",
    "ab_test_embed_code_heading" => "A/B Test Embed Code",
    "ab_test_embed_code_desc" => "Copy and paste this code where you want to display the A/B test. The system will randomly select one of the variations for each visitor.",
    "back_to_ab_tests_list" => "Back to A/B Tests List",
    "ab_test_error_not_found" => "A/B Test not found or does not belong to you.",
    "ab_test_variation_add_success" => "Variation added to the test successfully.",
    "ab_test_variation_add_error" => "Error adding variation. It might already exist in this test.",
    "ab_test_error_variation_limit" => "Error: Limit of 4 variations per test reached.",
    "ab_test_variation_remove_success" => "Variation removed successfully.",
    "ab_test_variation_remove_error" => "Error removing variation. Cannot remove the control variation.",
    "ab_test_delete_success" => "A/B Test deleted successfully.",
    "ab_test_delete_error" => "Error deleting the A/B Test.",

];

