<?php
// /home/ubuntu/vtrius_web_system/src/Controllers/AuthController.php

namespace Vtrius\Controllers;

use Vtrius\Lib\Auth;

class AuthController {
    private Auth $auth;

    public function __construct() {
        // Ensure config is loaded (which starts session and sets up autoloading)
        require_once __DIR__ . '/../config.php';
        $this->auth = new Auth();
    }

    /**
     * Display the login page.
     */
    public function showLoginForm(): void {
        // If already logged in, redirect to dashboard
        if ($this->auth->isLoggedIn()) {
            $redirectUrl = $this->auth->isAdmin() ? '/admin/dashboard.php' : '/user/dashboard.php'; // Adjust paths as needed
            header('Location: ' . BASE_URL . $redirectUrl);
            exit;
        }
        // Load the login view
        $this->loadView('auth/login');
    }

    /**
     * Handle the login form submission.
     */
    public function handleLogin(): void {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            http_response_code(405); // Method Not Allowed
            echo "Method Not Allowed";
            exit;
        }

        $username = $_POST['username'] ?? '';
        $password = $_POST['password'] ?? '';

        if ($this->auth->login($username, $password)) {
            // Redirect based on role after successful login
            $redirectUrl = $this->auth->isAdmin() ? '/admin/dashboard.php' : '/user/dashboard.php'; // Adjust paths
            header('Location: ' . BASE_URL . $redirectUrl);
            exit;
        } else {
            // Login failed, reload login form with an error message
            $errorMessage = "Invalid username or password, or account inactive.";
            $this->loadView('auth/login', ['error' => $errorMessage]);
        }
    }

    /**
     * Handle user logout.
     */
    public function handleLogout(): void {
        $this->auth->logout();
        // Redirect to login page after logout
        header('Location: ' . BASE_URL . '/login.php'); // Adjust path
        exit;
    }

    /**
     * Simple view loader (can be expanded into a proper template engine later).
     *
     * @param string $viewName The name of the view file (e.g., 'auth/login').
     * @param array $data Data to pass to the view.
     */
    private function loadView(string $viewName, array $data = []): void {
        // Make data available as variables in the view
        extract($data);

        $viewPath = APP_ROOT . '/Views/' . $viewName . '.php';

        if (file_exists($viewPath)) {
            // Basic structure: include header, view content, footer
            $headerPath = APP_ROOT . '/Views/layouts/header.php';
            $footerPath = APP_ROOT . '/Views/layouts/footer.php';

            if (file_exists($headerPath)) include $headerPath;
            include $viewPath;
            if (file_exists($footerPath)) include $footerPath;
        } else {
            http_response_code(500);
            echo "Error: View file not found ({$viewPath})";
        }
    }
}

