<?php
// /home/ubuntu/web_init_debug.php
// WARNING: DELETE THIS FILE IMMEDIATELY AFTER USE!
// Leaving this file on the server is a security risk.

header("Content-Type: text/html; charset=utf-8");

echo "<!DOCTYPE html><html><head><title>Vtrius Database Initialization (Debug)</title></head><body>";
echo "<h1>Vtrius Database Initialization (Debug)</h1>";
echo "<p><strong>WARNING: DELETE THIS FILE (web_init.php) FROM THE 'public/' DIRECTORY IMMEDIATELY AFTER USE!</strong></p><hr>";

// Function to output messages
function output_message($message, $is_error = false, $is_debug = false) {
    $color = $is_error ? "red" : ($is_debug ? "blue" : "green");
    echo "<p style='color:{$color};'>" . htmlspecialchars($message) . "</p>";
    flush(); // Try to send output immediately
}

// --- Debugging Paths ---
output_message("--- Debugging Paths ---", false, true);
$scriptPath = __FILE__;
output_message("Script Path (__FILE__): " . $scriptPath, false, true);
$publicDir = __DIR__;
output_message("Script Directory (__DIR__): " . $publicDir, false, true);
$projectRoot = dirname($publicDir); // Go up one level from public/
output_message("Calculated Project Root: " . $projectRoot, false, true);
$configPath = $projectRoot . '/src/config.php';
output_message("Expected config.php Path: " . $configPath, false, true);

// --- Checking config.php ---
output_message("--- Checking config.php ---", false, true);
if (file_exists($configPath)) {
    output_message("SUCCESS: config.php FOUND at '{$configPath}'.", false);
    if (is_readable($configPath)) {
        output_message("SUCCESS: config.php is READABLE.", false);
    } else {
        output_message("ERROR: config.php exists but is NOT READABLE by the web server. Check file permissions (e.g., 644).", true);
        echo "<hr><p>Initialization failed due to permissions.</p></body></html>";
        exit;
    }
} else {
    output_message("ERROR: config.php NOT FOUND at '{$configPath}'. Please verify the file exists at this exact path on the server.", true);
    // Check if src directory exists
    $srcDir = $projectRoot . '/src';
    if (is_dir($srcDir)) {
        output_message("Debug: The 'src' directory exists at '{$srcDir}'.", false, true);
    } else {
        output_message("Debug: The 'src' directory was NOT FOUND at '{$srcDir}'.", true);
    }
    echo "<hr><p>Initialization failed because config.php was not found.</p></body></html>";
    exit;
}

// --- Checking open_basedir (if possible) ---
output_message("--- Checking PHP open_basedir restriction ---", false, true);
$openBasedir = ini_get('open_basedir');
if ($openBasedir) {
    output_message("Warning: PHP 'open_basedir' restriction is active: '{$openBasedir}'. This might prevent accessing files outside allowed paths. Ensure '{$projectRoot}' is included or the restriction is disabled.", false, true);
} else {
    output_message("Info: PHP 'open_basedir' restriction is not active or not detectable.", false, true);
}

// --- Attempting to Include Config ---
output_message("--- Attempting to Include Config ---", false, true);
try {
    require_once $configPath;
    output_message("SUCCESS: config.php included successfully.", false);
} catch (\Throwable $e) {
    output_message("ERROR: Failed to include config.php: " . $e->getMessage(), true);
    echo "<hr><p>Initialization failed during config inclusion.</p></body></html>";
    exit;
}

// --- Proceed with Initialization (if config included) ---
use Vtrius\Lib\Database;
use Vtrius\Models\User;

output_message("--- Initializing Database ---", false, true);
try {
    // Get connection (this also triggers schema creation if tables don't exist via initializeDatabase in Database class)
    $db = Database::getConnection();
    output_message("Database connection successful. Schema should be initialized (or already exists).");

} catch (\Exception $e) {
    output_message("Error initializing database schema: " . $e->getMessage(), true);
    echo "<hr><p>Initialization failed.</p></body></html>";
    exit(1);
}

output_message("--- Creating Initial Users ---", false, true);

$userModel = new User();

// Admin User
$adminUsername = "admin";
$adminPassword = "admin123";
$adminEmail = "admin@example.com";

try {
    if (!$userModel->findByUsername($adminUsername)) {
        $userId = $userModel->create($adminUsername, $adminPassword, $adminEmail, true, null);
        if ($userId) {
            output_message("Admin user '{$adminUsername}' created successfully (Password: {$adminPassword}).");
        } else {
            output_message("Failed to create admin user '{$adminUsername}'.", true);
        }
    } else {
        output_message("Admin user '{$adminUsername}' already exists.");
    }
} catch (\Exception $e) {
    output_message("Error creating admin user '{$adminUsername}': " . $e->getMessage(), true);
}

// Regular User
$testUsername = "testuser";
$testPassword = "test1234";
$testEmail = "test@example.com";
$expiryDate = null;
try {
    $expiryDate = (new DateTime("+30 days"))->format("Y-m-d H:i:s");
} catch (\Exception $e) { /* Handle potential DateTime exception */ }

try {
    if (!$userModel->findByUsername($testUsername)) {
        $userId = $userModel->create($testUsername, $testPassword, $testEmail, false, $expiryDate);
        if ($userId) {
            output_message("Test user '{$testUsername}' created successfully (Password: {$testPassword}, Expires: {$expiryDate}).");
        } else {
            output_message("Failed to create test user '{$testUsername}'.", true);
        }
    } else {
        output_message("Test user '{$testUsername}' already exists.");
    }
} catch (\Exception $e) {
    output_message("Error creating test user '{$testUsername}': " . $e->getMessage(), true);
}

output_message("Database initialization process complete.");
echo "<hr><p><strong>REMINDER: DELETE THIS FILE (web_init.php) FROM THE 'public/' DIRECTORY NOW!</strong></p>";
echo "</body></html>";

?>

