<?php
// db/database.php

// Define the path to the SQLite database file
define("DB_PATH", __DIR__ . "/licenses.db");
define("PDO_DSN", "sqlite:" . DB_PATH);

function get_db_connection() {
    static $pdo = null;
    if ($pdo === null) {
        try {
            if (!is_writable(__DIR__)) {
                @chmod(__DIR__, 0755);
                if (!is_writable(__DIR__)) {
                     die("Database directory 'db/' is not writable. Please check permissions (set to 755 or 775).");
                }
            }
            
            $pdo = new PDO(PDO_DSN);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
            initialize_database($pdo);
        } catch (PDOException $e) {
            die("Database Connection/Initialization Error: " . $e->getMessage() . " (Check if 'db/' directory is writable)");
        }
    }
    return $pdo;
}

function initialize_database(PDO $pdo) {
    $pdo->exec("CREATE TABLE IF NOT EXISTS licenses (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        license_key TEXT UNIQUE NOT NULL,
        client_name TEXT,
        status TEXT NOT NULL DEFAULT 'inactive',
        expiry_date DATETIME,
        site_url TEXT,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        updated_at DATETIME DEFAULT CURRENT_TIMESTAMP
    )");
    $pdo->exec("CREATE INDEX IF NOT EXISTS idx_license_key ON licenses (license_key)");
    
    $trigger_check = $pdo->query("SELECT name FROM sqlite_master WHERE type='trigger' AND name='update_license_updated_at'")->fetch();
    if (!$trigger_check) {
        $pdo->exec("CREATE TRIGGER update_license_updated_at
            AFTER UPDATE ON licenses
            FOR EACH ROW
            BEGIN
                UPDATE licenses SET updated_at = CURRENT_TIMESTAMP WHERE id = OLD.id;
            END;");
    }
}

get_db_connection();

?>
