<?php


// admin/index.php
session_start();

// --- Configuration ---
// IMPORTANT: Change this password!
define("ADMIN_PASSWORD", "TR#2025@ggm"); 
$page_title = "License Management";

// Include database connection and helper functions
require_once __DIR__ . "/../db/database.php";
require_once __DIR__ . "/../includes/functions.php";

// --- Authentication ---
$is_logged_in = isset($_SESSION["admin_logged_in"]) && $_SESSION["admin_logged_in"] === true;

// Handle Login Attempt
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["action"]) && $_POST["action"] === "login") {
    if (isset($_POST["password"]) && $_POST["password"] === ADMIN_PASSWORD) {
        $_SESSION["admin_logged_in"] = true;
        $is_logged_in = true;
        set_flash_message("Login successful!");
        header("Location: index.php");
        exit;
    } else {
        $login_error = "Invalid password";
    }
}

// Handle Logout
if (isset($_GET["action"]) && $_GET["action"] === "logout") {
    session_destroy();
    header("Location: index.php");
    exit;
}

// --- Login Gate ---
if (!$is_logged_in) {
?>
<!DOCTYPE html>
<html>
<head><title>Admin Login</title>
<style>
    body { font-family: sans-serif; margin: 40px; background-color: #f4f7f6; }
    h2 { text-align: center; color: #333; }
    form { background-color: #fff; padding: 20px; border-radius: 5px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); max-width: 300px; margin: 20px auto; }
    label { display: block; margin-bottom: 8px; font-weight: bold; }
    input[type="password"] { width: calc(100% - 22px); padding: 10px; margin-bottom: 15px; border: 1px solid #ccc; border-radius: 4px; }
    button { padding: 10px 15px; cursor: pointer; background-color: #007bff; color: white; border: none; border-radius: 4px; font-size: 1em; width: 100%; }
    button:hover { background-color: #0056b3; }
    .error { color: red; text-align: center; margin-top: 10px; }
</style>
</head>
<body>
    <form method="post">
        <h2>Admin Login</h2>
        <?php if (isset($login_error)): ?>
            <p class="error"><?php echo htmlspecialchars($login_error); ?></p>
        <?php endif; ?>
        <input type="hidden" name="action" value="login">
        <label for="password">Password:</label>
        <input type="password" id="password" name="password" required>
        <button type="submit">Login</button>
    </form>
</body>
</html>
<?php
    exit; // Stop script execution for non-logged-in users
}

// --- Actions for Logged-in Users ---
$pdo = get_db_connection();

// Handle Generate License
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["action"]) && $_POST["action"] === "generate") {
    $client_name = isset($_POST["client_name"]) ? trim($_POST["client_name"]) : null;
    $new_key = generate_license_key();
    
    try {
        $stmt = $pdo->prepare("INSERT INTO licenses (license_key, client_name) VALUES (?, ?)");
        $stmt->execute([$new_key, $client_name]);
        set_flash_message("New license key {$new_key} generated successfully." . ($client_name ? " for {$client_name}." : "."));
    } catch (PDOException $e) {
        set_flash_message("Error generating license: " . $e->getMessage(), "error");
    }
    header("Location: index.php");
    exit;
}

// Handle Activate License
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["action"]) && $_POST["action"] === "activate" && isset($_POST["license_id"])) {
    $license_id = filter_input(INPUT_POST, "license_id", FILTER_VALIDATE_INT);
    $is_lifetime = isset($_POST["lifetime"]);
    $duration_days = filter_input(INPUT_POST, "duration_days", FILTER_VALIDATE_INT, ["options" => ["default" => 30, "min_range" => 1]]);
    
    if ($license_id) {
        try {
            $expiry_date = null;
            if (!$is_lifetime) {
                $expiry_date = (new DateTime())->add(new DateInterval("P{$duration_days}D"))->format("Y-m-d H:i:s");
            }
            $stmt = $pdo->prepare("UPDATE licenses SET status = \"active\", expiry_date = ? WHERE id = ?");
            $stmt->execute([$expiry_date, $license_id]);
            set_flash_message("License activated successfully." . ($is_lifetime ? " (Lifetime)" : " Expires on {$expiry_date}"));
        } catch (PDOException $e) {
            set_flash_message("Error activating license: " . $e->getMessage(), "error");
        }
    }
    header("Location: index.php");
    exit;
}

// Handle Deactivate License
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["action"]) && $_POST["action"] === "deactivate" && isset($_POST["license_id"])) {
    $license_id = filter_input(INPUT_POST, "license_id", FILTER_VALIDATE_INT);
    if ($license_id) {
        try {
            $stmt = $pdo->prepare("UPDATE licenses SET status = \"inactive\" WHERE id = ?");
            $stmt->execute([$license_id]);
            set_flash_message("License deactivated successfully.");
        } catch (PDOException $e) {
            set_flash_message("Error deactivating license: " . $e->getMessage(), "error");
        }
    }
    header("Location: index.php");
    exit;
}

// --- Display Admin Panel ---

// Fetch licenses and check validity
$licenses = [];
try {
    $stmt = $pdo->query("SELECT * FROM licenses ORDER BY created_at DESC");
    $licenses_raw = $stmt->fetchAll();
    foreach ($licenses_raw as $lic) {
        // Check and update status if expired before displaying
        check_license_validity($pdo, $lic["id"]); 
        // Re-fetch after potential update
        $stmt_single = $pdo->prepare("SELECT * FROM licenses WHERE id = ?");
        $stmt_single->execute([$lic["id"]]);
        $licenses[] = $stmt_single->fetch(); 
    }
} catch (PDOException $e) {
    set_flash_message("Error fetching licenses: " . $e->getMessage(), "error");
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_title); ?></title>
    <style>
        body { font-family: sans-serif; margin: 20px; background-color: #f4f7f6; color: #333; }
        h1, h2 { color: #444; }
        .header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; padding-bottom: 10px; border-bottom: 1px solid #ddd; }
        .header a { text-decoration: none; color: #007bff; padding: 5px 10px; border: 1px solid #007bff; border-radius: 4px; }
        .header a:hover { background-color: #007bff; color: white; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; background-color: #fff; box-shadow: 0 1px 3px rgba(0,0,0,0.1); }
        th, td { border: 1px solid #ddd; padding: 10px 12px; text-align: left; vertical-align: middle; }
        th { background-color: #e9ecef; font-weight: bold; }
        tr:nth-child(even) { background-color: #f9f9f9; }
        .status-active { color: #28a745; font-weight: bold; }
        .status-inactive { color: #6c757d; }
        .status-expired { color: #fd7e14; font-weight: bold; }
        .status-invalid { color: #dc3545; font-weight: bold; }
        .actions form { display: inline-block; margin: 0 5px 5px 0; }
        .actions button { padding: 5px 10px; cursor: pointer; border: none; border-radius: 4px; font-size: 0.9em; }
        .btn-danger { background-color: #dc3545; color: white; }
        .btn-warning { background-color: #ffc107; color: #333; }
        .btn-success { background-color: #28a745; color: white; }
        .btn-secondary { background-color: #6c757d; color: white; }
        .new-license { margin-bottom: 30px; background-color: #fff; padding: 20px; border-radius: 5px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); }
        .new-license label { display: block; margin-bottom: 5px; font-weight: bold; }
        .new-license input[type="text"] { width: 300px; padding: 8px; margin-bottom: 10px; border: 1px solid #ccc; border-radius: 4px; }
        .new-license button { padding: 10px 15px; cursor: pointer; background-color: #007bff; color: white; border: none; border-radius: 4px; font-size: 1em; }
        .new-license button:hover { background-color: #0056b3; }
        .flash-message { padding: 10px; margin-bottom: 15px; border-radius: 4px; }
        .flash-success { background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .flash-error { background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        .activate-form label, .activate-form input { display: inline-block; margin-right: 10px; vertical-align: middle; }
        .activate-form input[type="number"] { width: 60px; padding: 5px; }
        code { background-color: #e9ecef; padding: 2px 4px; border-radius: 3px; font-family: monospace; }
    </style>
</head>
<body>
    <div class="header">
        <h1><?php echo htmlspecialchars($page_title); ?></h1>
        <a href="?action=logout">Logout</a>
    </div>

    <?php display_flash_message(); ?>

    <div class="new-license">
        <h2>Generate New License</h2>
        <form action="index.php" method="post">
            <input type="hidden" name="action" value="generate">
            <div>
                <label for="client_name">Client Name (Optional):</label>
                <input type="text" id="client_name" name="client_name" placeholder="Enter client name">
            </div>
            <button type="submit">Generate New Inactive License Key</button>
        </form>
    </div>

    <h2>Existing Licenses</h2>
    <table>
        <thead>
            <tr>
                <th>License Key</th>
                <th>Client Name</th>
                <th>Status</th>
                <th>Expiry Date</th>
                <th>Site URL</th>
                <th>Created At</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($licenses)): ?>
            <tr>
                <td colspan="7">No licenses found.</td>
            </tr>
            <?php else: ?>
                <?php foreach ($licenses as $license): ?>
                <tr>
                    <td><code><?php echo htmlspecialchars($license["license_key"]); ?></code></td>
                    <td><?php echo htmlspecialchars($license["client_name"] ?: "--"); ?></td>
                    <td><span class="status-<?php echo htmlspecialchars($license["status"]); ?>"><?php echo htmlspecialchars($license["status"]); ?></span></td>
                    <td>
                        <?php 
                        if ($license["status"] === "active" && $license["expiry_date"] === null) {
                            echo "Lifetime";
                        } elseif ($license["expiry_date"]) {
                            echo htmlspecialchars((new DateTime($license["expiry_date"]))->format("Y-m-d H:i:s"));
                        } else {
                            echo "N/A";
                        }
                        ?>
                    </td>
                    <td><?php echo htmlspecialchars($license["site_url"] ?: "N/A"); ?></td>
                    <td><?php echo htmlspecialchars((new DateTime($license["created_at"]))->format("Y-m-d H:i:s")); ?></td>
                    <td class="actions">
                        <?php if ($license["status"] === "inactive" || $license["status"] === "expired"): ?>
                            <form class="activate-form" action="index.php" method="post">
                                <input type="hidden" name="action" value="activate">
                                <input type="hidden" name="license_id" value="<?php echo $license["id"]; ?>">
                                <label><input type="checkbox" name="lifetime"> Lifetime</label>
                                <label>Days: <input type="number" name="duration_days" value="30" min="1"></label>
                                <button type="submit" class="btn-success">Activate</button>
                            </form>
                        <?php elseif ($license["status"] === "active"): ?>
                            <form action="index.php" method="post">
                                <input type="hidden" name="action" value="deactivate">
                                <input type="hidden" name="license_id" value="<?php echo $license["id"]; ?>">
                                <button type="submit" class="btn-warning">Deactivate</button>
                            </form>
                        <?php endif; ?>
                        <!-- Add Delete button later if needed -->
                    </td>
                </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</body>
</html>

